%clear all;
% Parameter
L=2;
sample_s=zeros(10,5);
delta_=2000;
runs=10;
test_max=10;
d=5;

for j=3:5
    lm=0.2*j-0.1;
    for i=1:5
        N0 = i*delta_; % sampling number

        K = 3;    % number of nodes in hidden layer

        loop_n = 10000;

        eta = 20; % stepsize of gradient descent

        count=0;
        for test=1:test_max
            %  mix-gaussian parametere-2
            %{
            x_1=1e-1*randn(d,round(N0*lm));
            x_2=10*randn(d,round(N0*(1-lm)));
            x_N=cat(2,x_1,x_2);
            r=randperm(size(x_N,2));
            x_N=x_N(:,r);
            %}
            
            p=[lm 1-lm];
            mu1=0*ones(1,d);
            mu2=-0*ones(1,d);
            mu=cat(1,mu1,mu2);         

            sigma=ones(1,d,2);
            
            sigma(:,:,1)=1*ones(1,d);
            sigma(:,:,2)=5*ones(1,d);
            x_N=rand_mixedgau(d,N0,mu,sigma,p);
            
                   
            % Generate W
            
            W = 1*randn( d, K );

            % Algorithm

            %errit = zeros( loop_n , 1 );
      
            [H_matrix, H_FCN] = Conv_sigmoid_FCN( x_N, W );
            y_N=zeros(1,N0);

            for ind=1:N0
                y_N(ind)=binornd(1,H_FCN(ind));
            end
            W_out=zeros(d*K,runs);
            parfor run=1:runs
                temp = randn( d , K );
                W_0 = W + 0.1 * norm( W , 'fro' ) * temp / norm( temp ,  'fro' );
                W_t0=W_0;
                eta=500/(lm*1e-4+(1-lm)*100);
                eta=20;
                for l = 1 : loop_n
           
                    GD=Gradient_crossentropy(x_N,y_N,W_t0);
                    W_t = W_t0 - eta * GD;
                    %{
                    errit( l ) = norm( W-W_t , 'fro') / norm( W , 'fro');
                    if isnan(errit(l))
                        break;
                    end
                    %}
                    W_t0=W_t;
                end
                W_out(:,run)=W_t(:);
            end
            w_bar=mean(W_out,2);
            W_bar=ones(d*K,runs).*w_bar;
            Error=norm(W_bar-W_out,'fro')/sqrt(runs);
            if Error<=1e-3
               count=count+1;
            end
        end
        sample_s(11-i,j)=count/test_max;
        
        if i>3 & sum(sample_s([11-i:13-i],j))>=2.9
            sample_s([1:11-i],j)=1;
            break;
        end
        
    end
end


imshow(sample_s,'InitialMagnification',4000); 

axis on; 
xlabel('Dimension of data');
ylabel('Number of Samples');
set(gca,'XTick',[4 8 12 16 20]);
set(gca,'Xticklabel',{'20','40','60','80','100'});
set(gca,'YTick',[ 1 6 11 ]);
set(gca,'Yticklabel',{'150000','100000','50000'});
set(gca,'fontsize',18,'fontname', 'Times New Roman');
